<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Comdev\Component\Onecore\Administrator\Controller;

use Joomla\CMS\MVC\Controller\AdminController;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Categories list controller class.
 *
 * @since  1.0.0
 */
class CategoriesController extends AdminController
{
	/**
	 * The prefix to use with controller messages.
	 *
	 * @var    string
	 * @since  1.0.0
	 */
	protected $text_prefix = 'COM_ONECORE_CATEGORIES';

	/**
	 * Proxy for getModel.
	 *
	 * @param   string  $name    The model name. Optional.
	 * @param   string  $prefix  The class prefix. Optional.
	 * @param   array   $config  Configuration array for model. Optional.
	 *
	 * @return  \Joomla\CMS\MVC\Model\BaseDatabaseModel
	 *
	 * @since   1.0.0
	 */
	public function getModel($name = 'Categories', $prefix = 'Administrator', $config = ['ignore_request' => true])
	{
		$app      = \Joomla\CMS\Factory::getApplication();
		$option   = $app->input->getCmd('option');
		$viewName = $app->input->getCmd('view', 'categories');

		// List view should use Categories (ListModel); item view uses Category (AdminModel)
		if ($name === 'Categories' || $viewName === 'categories') {
			return parent::getModel('Categories', $prefix, $config);
		}

		// Fallback for single item operations
		if ($name === 'Category' || $viewName === 'category') {
			$model = parent::getModel('Category', $prefix, $config);

			// If parent fails, try direct instantiation
			if (!$model) {
				$className = 'Comdev\\Component\\Onecore\\Administrator\\Model\\Categories\\CategoryModel';
				if (class_exists($className)) {
					// Get MVCFactory from component
					$component = \Joomla\CMS\Factory::getApplication()->bootComponent($option);
					$factory   = $component->getMVCFactory();

					$model = new $className($config, $factory);

					// Set required dependencies
					if ($model instanceof \Joomla\Database\DatabaseAwareInterface) {
						$model->setDatabase(\Joomla\CMS\Factory::getContainer()->get(\Joomla\Database\DatabaseInterface::class));
					}
					if ($model instanceof \Joomla\CMS\Form\FormFactoryAwareInterface) {
						$model->setFormFactory(\Joomla\CMS\Factory::getContainer()->get(\Joomla\CMS\Form\FormFactoryInterface::class));
					}
					if ($model instanceof \Joomla\Event\DispatcherAwareInterface) {
						$model->setDispatcher(\Joomla\CMS\Factory::getContainer()->get(\Joomla\Event\DispatcherInterface::class));
					}
				}
			}

			return $model;
		}

		return parent::getModel($name, $prefix, $config);
	}
}
