-- Add menu item for Custom Field Groups if it doesn't exist
-- This update ensures the Custom Field Groups menu item is visible in the admin sidebar

-- Get component and parent IDs
SET @component_id = (SELECT `extension_id` FROM `#__extensions` WHERE `element` = 'com_onecore' AND `type` = 'component' LIMIT 1);
SET @parent_id = (SELECT `id` FROM `#__menu` WHERE `menutype` = 'main' AND `link` LIKE 'index.php?option=com_onecore%' AND `parent_id` = 1 LIMIT 1);

-- Check if menu item already exists
SET @menu_exists = (SELECT COUNT(*) FROM `#__menu` WHERE `menutype` = 'main' AND `link` = 'index.php?option=com_onecore&view=customfieldgroups' LIMIT 1);

-- Get max ordering and rgt for positioning
SET @max_ordering = (SELECT COALESCE(MAX(`ordering`), 0) FROM `#__menu` WHERE `menutype` = 'main' AND `parent_id` = @parent_id);
SET @max_rgt = (SELECT COALESCE(MAX(`rgt`), 0) FROM `#__menu` WHERE `menutype` = 'main' AND `parent_id` = @parent_id);
SET @parent_level = (SELECT COALESCE(MAX(`level`), 1) FROM `#__menu` WHERE `menutype` = 'main' AND `parent_id` = @parent_id);

-- Only insert if component exists, parent exists, and menu item doesn't exist
INSERT INTO `#__menu` (
    `menutype`, 
    `title`, 
    `alias`, 
    `note`, 
    `link`, 
    `type`, 
    `published`, 
    `parent_id`, 
    `component_id`, 
    `ordering`, 
    `checked_out`, 
    `checked_out_time`, 
    `browserNav`, 
    `access`, 
    `img`, 
    `template_style_id`, 
    `params`, 
    `lft`, 
    `rgt`, 
    `level`, 
    `home`, 
    `language`, 
    `client_id`, 
    `created`, 
    `created_by`, 
    `created_by_alias`, 
    `modified`, 
    `modified_by`, 
    `publish_up`, 
    `publish_down`
)
SELECT 
    'main',
    'COM_ONECORE_CUSTOMFIELDGROUPS',
    'com-onecore-customfieldgroups',
    '',
    'index.php?option=com_onecore&view=customfieldgroups',
    'component',
    1,
    @parent_id,
    @component_id,
    @max_ordering + 1,
    0,
    NULL,
    0,
    1,
    'class:tags',
    0,
    '{}',
    @max_rgt + 1,
    @max_rgt + 2,
    @parent_level + 1,
    0,
    '*',
    1,
    NOW(),
    0,
    '',
    NULL,
    0,
    NULL,
    NULL
WHERE @component_id IS NOT NULL 
  AND @parent_id IS NOT NULL 
  AND @menu_exists = 0;

-- Update lft/rgt values for all menu items after the new one (only if new item was inserted)
SET @new_menu_id = (SELECT `id` FROM `#__menu` WHERE `menutype` = 'main' AND `link` = 'index.php?option=com_onecore&view=customfieldgroups' LIMIT 1);

UPDATE `#__menu` 
SET `rgt` = `rgt` + 2 
WHERE `menutype` = 'main' 
  AND `rgt` > @max_rgt
  AND `id` != @new_menu_id
  AND @new_menu_id IS NOT NULL;

UPDATE `#__menu` 
SET `lft` = `lft` + 2 
WHERE `menutype` = 'main' 
  AND `lft` > @max_rgt
  AND @new_menu_id IS NOT NULL;
