-- Migration: Move address data from #__one_content to separate table #__one_content_addresses
-- Version: 1.0.8

-- Create new table for addresses
CREATE TABLE IF NOT EXISTS `#__one_content_addresses` (
  `id` int NOT NULL AUTO_INCREMENT,
  `content_id` int NOT NULL,
  `address` varchar(255) NOT NULL DEFAULT '',
  `address_street` varchar(255) NOT NULL DEFAULT '',
  `address_street_number` varchar(20) NOT NULL DEFAULT '',
  `address_postal_code` varchar(20) NOT NULL DEFAULT '',
  `address_city` varchar(100) NOT NULL DEFAULT '',
  `address_country` varchar(100) NOT NULL DEFAULT '',
  `latitude` decimal(10,8) DEFAULT NULL,
  `longitude` decimal(11,8) DEFAULT NULL,
  `created` datetime NOT NULL,
  `modified` datetime,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_content_id` (`content_id`),
  KEY `idx_location` (`latitude`, `longitude`),
  CONSTRAINT `fk_one_content_addresses_content` FOREIGN KEY (`content_id`) REFERENCES `#__one_content` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

-- Migrate existing address data from #__one_content to #__one_content_addresses
-- Only migrate if columns exist
INSERT INTO `#__one_content_addresses` (`content_id`, `address`, `latitude`, `longitude`, `created`)
SELECT `id`, COALESCE(`address`, ''), `latitude`, `longitude`, NOW()
FROM `#__one_content`
WHERE EXISTS (
  SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS 
  WHERE TABLE_SCHEMA = DATABASE() 
  AND TABLE_NAME = '#__one_content' 
  AND COLUMN_NAME = 'address'
)
AND (`address` != '' OR `latitude` IS NOT NULL OR `longitude` IS NOT NULL);

-- Remove address fields from #__one_content table
-- Drop key first if it exists
SET @sql = (SELECT IF(
  (SELECT COUNT(*) FROM INFORMATION_SCHEMA.STATISTICS 
   WHERE TABLE_SCHEMA = DATABASE() 
   AND TABLE_NAME = '#__one_content' 
   AND INDEX_NAME = 'idx_location') > 0,
  'ALTER TABLE `#__one_content` DROP KEY `idx_location`;',
  'SELECT 1;'
));
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Drop columns if they exist
SET @sql = (SELECT IF(
  (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
   WHERE TABLE_SCHEMA = DATABASE() 
   AND TABLE_NAME = '#__one_content' 
   AND COLUMN_NAME = 'address') > 0,
  'ALTER TABLE `#__one_content` DROP COLUMN `address`, DROP COLUMN `latitude`, DROP COLUMN `longitude`;',
  'SELECT 1;'
));
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
