-- Create custom fields tables

CREATE TABLE IF NOT EXISTS `#__one_customfields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `category_id` int NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT 'input',
  `required` tinyint NOT NULL DEFAULT 0,
  `height` int NOT NULL DEFAULT 0,
  `ordering` int NOT NULL DEFAULT 0,
  `display_label` tinyint NOT NULL DEFAULT 1,
  `label_position` varchar(10) NOT NULL DEFAULT 'next',
  `searchable` tinyint NOT NULL DEFAULT 0,
  `pos_items` varchar(20) NOT NULL DEFAULT 'none',
  `pos_item` varchar(20) NOT NULL DEFAULT 'none',
  `pos_module` varchar(20) NOT NULL DEFAULT 'none',
  `published` tinyint NOT NULL DEFAULT 1,
  `created` datetime NOT NULL,
  `modified` datetime,
  PRIMARY KEY (`id`),
  KEY `idx_category_id` (`category_id`),
  KEY `idx_published` (`published`),
  KEY `idx_ordering` (`ordering`),
  KEY `idx_searchable` (`searchable`),
  KEY `idx_type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__one_customfield_values` (
  `id` int NOT NULL AUTO_INCREMENT,
  `content_id` int NOT NULL,
  `field_id` int NOT NULL,
  `value` mediumtext NOT NULL,
  `created` datetime NOT NULL,
  `modified` datetime,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_content_field` (`content_id`, `field_id`),
  KEY `idx_field_id` (`field_id`),
  CONSTRAINT `fk_one_customfield_values_content` FOREIGN KEY (`content_id`) REFERENCES `#__one_content` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_one_customfield_values_field` FOREIGN KEY (`field_id`) REFERENCES `#__one_customfields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

