-- Add nested set columns and path for #__one_categories
ALTER TABLE `#__one_categories`
    ADD COLUMN `lft` int NOT NULL DEFAULT 0 AFTER `parent_id`,
    ADD COLUMN `rgt` int NOT NULL DEFAULT 0 AFTER `lft`,
    ADD COLUMN `level` int NOT NULL DEFAULT 0 AFTER `rgt`,
    ADD COLUMN `path` varchar(1024) NOT NULL DEFAULT '' AFTER `alias`;

-- Ensure extension column exists (in case previous migration not run)
ALTER TABLE `#__one_categories`
    ADD COLUMN IF NOT EXISTS `extension` varchar(50) NOT NULL DEFAULT 'com_onecore' AFTER `id`;

-- Indexes for nested set and extension
ALTER TABLE `#__one_categories`
    ADD KEY `idx_lft_rgt` (`lft`, `rgt`),
    ADD KEY `idx_extension` (`extension`);
