<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Comdev\Component\Onecore\Site\Helper\ContentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

/** @var \Comdev\Component\Onecore\Site\View\Item\HtmlView $this */
$item = $this->item;
$params = $this->params;
$user = Factory::getUser();

// Load jQuery, FontAwesome, Bootstrap Modal and Carousel using Joomla WebAssetManager
$wa = $this->getDocument()->getWebAssetManager();
$wa->useScript('jquery')
	->useStyle('fontawesome')
	->useScript('bootstrap.modal')
	->useScript('bootstrap.carousel');

// Add inline CSS to hide template sidebars - more reliable than external CSS
$document = Factory::getApplication()->getDocument();
$document->addStyleDeclaration("
/* Hide Joomla template sidebars for OneCore item view */
/* But keep OneCore's own sidebar visible */
.tm-sidebar:not(.one_item_sidebar):not([class*='onecore-']),
.sidebar:not(.one_item_sidebar):not([class*='onecore-']):not([class*='one_']),
aside.sidebar:not(.one_item_sidebar):not([class*='onecore-']):not([class*='one_']),
.sidebar-left:not(.one_item_sidebar):not([class*='onecore-']),
.sidebar-right:not(.one_item_sidebar):not([class*='onecore-']),
#sidebar:not(.one_item_sidebar):not([class*='onecore-']),
.page-sidebar:not(.one_item_sidebar):not([class*='onecore-']),
.blog-sidebar:not(.one_item_sidebar):not([class*='onecore-']) {
    display: none !important;
}

/* Hide grid columns that are NOT OneCore sidebar */
body:not(.onecore-sidebar-active) .uk-width-1-4:not([class*='one_']):not([class*='onecore-']),
body:not(.onecore-sidebar-active) .uk-width-1-3:not([class*='one_']):not([class*='onecore-']),
body:not(.onecore-sidebar-active) .span3:not([class*='one_']):not([class*='onecore-']),
body:not(.onecore-sidebar-active) .span4:not([class*='one_']):not([class*='onecore-']),
body:not(.onecore-sidebar-active) .col-md-3:not([class*='one_']):not([class*='onecore-']),
body:not(.onecore-sidebar-active) .col-md-4:not([class*='one_']):not([class*='onecore-']),
body:not(.onecore-sidebar-active) .col-lg-3:not([class*='one_']):not([class*='onecore-']),
body:not(.onecore-sidebar-active) .col-lg-4:not([class*='one_']):not([class*='onecore-']) {
    display: none !important;
}

/* Force main content to full width ONLY when OneCore sidebar is not active */
body:not(.onecore-sidebar-active) .tm-main:not([class*='one_']),
body:not(.onecore-sidebar-active) .main-content:not([class*='one_']),
body:not(.onecore-sidebar-active) .content-main:not([class*='one_']),
body:not(.onecore-sidebar-active) main.main:not([class*='one_']),
body:not(.onecore-sidebar-active) .uk-width-3-4:not([class*='one_']),
body:not(.onecore-sidebar-active) .uk-width-2-3:not([class*='one_']),
body:not(.onecore-sidebar-active) .span8:not([class*='one_']),
body:not(.onecore-sidebar-active) .span9:not([class*='one_']),
body:not(.onecore-sidebar-active) .col-md-8:not([class*='one_']),
body:not(.onecore-sidebar-active) .col-md-9:not([class*='one_']),
body:not(.onecore-sidebar-active) .col-lg-8:not([class*='one_']),
body:not(.onecore-sidebar-active) .col-lg-9:not([class*='one_']) {
    width: 100% !important;
    max-width: 100% !important;
    flex: 0 0 100% !important;
}
");

// Get all images for slider
$allImages = ContentHelper::getAllImages($item->images);

// Sidebar (modules) settings
$showSidebar = (int) $params->get('show_item_sidebar', 0) === 1;
$sidebarPosition = trim((string) $params->get('item_sidebar_position', 'onecore-item-sidebar'));
$sidebarWidth = (int) $params->get('item_sidebar_width', 4);

if (!in_array($sidebarWidth, [3, 4, 5], true)) {
	$sidebarWidth = 4;
}

$mainWidth = 12 - $sidebarWidth;
$sidebarModules = [];

if ($showSidebar && $sidebarPosition !== '') {
	$sidebarModules = ModuleHelper::getModules($sidebarPosition) ?: [];
}

$hasSidebarModules = !empty($sidebarModules);
$hasSidebarCustomFields = !empty($item->customfields_sidebar);

$showMap = (int) $params->get('show_map', 1) === 1;
$mapPositionItem = $params->get('map_position_item', 'sidebar');
$hasMap = $showMap && !empty($item->latitude) && !empty($item->longitude);
$showMapInSidebar = $hasMap && ($mapPositionItem === 'sidebar');

// Item blocks (contact, customfields, map, address): show + order. Backward compat: show_contact_form, contact_form_position.
$blockContactShow = (int) $params->get('item_block_contact_show', $params->get('show_contact_form', 1)) === 1;
$blockContactOrder = (int) $params->get('item_block_contact_order', 1);
$blockContactPosition = $params->get('item_block_contact_position', $params->get('contact_form_position', 'sidebar'));
$hasContactForm = $blockContactShow && !empty($item->created_by);
$contactFormInSidebar = $hasContactForm && ($blockContactPosition === 'sidebar');

$blockCustomfieldsShow = (int) $params->get('item_block_customfields_show', 1) === 1;
$blockCustomfieldsOrder = (int) $params->get('item_block_customfields_order', 2);

$blockMapShow = (int) $params->get('item_block_map_show', 1) === 1;
$blockMapOrder = (int) $params->get('item_block_map_order', 3);

$blockAddressShow = (int) $params->get('item_block_address_show', 1) === 1;
$blockAddressOrder = (int) $params->get('item_block_address_order', 4);
$hasAddress = !empty($item->address) || !empty($item->address_street) || !empty($item->address_city);

// Build ordered sidebar blocks (only blocks that appear in sidebar)
$sidebarBlocks = [];
if ($blockMapShow && $showMapInSidebar) {
	$sidebarBlocks[] = ['id' => 'map', 'order' => $blockMapOrder];
}
if ($blockAddressShow && $hasAddress) {
	$sidebarBlocks[] = ['id' => 'address', 'order' => $blockAddressOrder];
}
if ($blockCustomfieldsShow && $hasSidebarCustomFields) {
	$sidebarBlocks[] = ['id' => 'customfields', 'order' => $blockCustomfieldsOrder];
}
if ($contactFormInSidebar) {
	$sidebarBlocks[] = ['id' => 'contact', 'order' => $blockContactOrder];
}
usort($sidebarBlocks, static function ($a, $b) { return $a['order'] <=> $b['order']; });

$renderSidebar = $showSidebar && ($hasSidebarModules || !empty($sidebarBlocks) || $user->authorise('core.admin'));

// Add body class when OneCore sidebar is active
if ($renderSidebar) {
	$document->addScriptDeclaration("
		document.addEventListener('DOMContentLoaded', function() {
			document.body.classList.add('onecore-sidebar-active');
		});
	");
}

$layoutBase = JPATH_SITE . '/components/com_onecore/layouts';
?>
<div class="com-onecore-item item-page one_container">
	<?php if ($params->get('show_page_heading')) : ?>
		<div class="page-header one_header">
			<h1 class="one_page_heading"><?php echo $this->escape($params->get('page_heading')); ?></h1>
		</div>
	<?php endif; ?>

	<?php if ($params->get('show_title', 1)) : ?>
		<h2 class="item-title one_title mb-3"><?php echo $this->escape($item->title); ?></h2>
	<?php endif; ?>

	<?php if (!empty($item->customfields_under_title)) : ?>
		<?php foreach ($item->customfields_under_title as $group) : ?>
			<div class="one_customfield_group one_customfield_group--under-title mb-3">
				<?php if (!empty($group->show_title) && !empty($group->title)) : ?>
					<h3 class="one_customfield_group_title"><?php echo htmlspecialchars((string) $group->title, ENT_QUOTES, 'UTF-8'); ?></h3>
				<?php endif; ?>
				<?php if (!empty($group->show_description) && !empty($group->description)) : ?>
					<div class="one_customfield_group_description mb-2"><?php echo HTMLHelper::_('content.prepare', $group->description, '', 'com_onecore.customfieldgroup'); ?></div>
				<?php endif; ?>
				<?php if (!empty($group->fields)) : ?>
					<div class="one_customfields one_customfields--under-title">
						<?php foreach ($group->fields as $cf) : ?>
							<div class="one_customfield">
								<?php if (!empty($cf->display_label)) : ?>
									<?php if (($cf->label_position ?? 'next') === 'over') : ?>
										<div class="one_customfield_label"><?php echo htmlspecialchars((string) $cf->title, ENT_QUOTES, 'UTF-8'); ?></div>
										<div class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></div>
									<?php else : ?>
										<span class="one_customfield_label"><?php echo htmlspecialchars((string) $cf->title, ENT_QUOTES, 'UTF-8'); ?>:</span>
										<span class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></span>
									<?php endif; ?>
								<?php else : ?>
									<span class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></span>
								<?php endif; ?>
							</div>
						<?php endforeach; ?>
					</div>
				<?php endif; ?>
			</div>
		<?php endforeach; ?>
	<?php endif; ?>

	<!-- Category and Date - Full Width -->
	<div class="item-meta d-flex flex-wrap gap-3 mb-4 one_meta">
		<?php if ($params->get('show_category', 1)) : ?>
			<?php
			$categories = ContentHelper::getCategories($item->id);
			if (!empty($categories)) :
			?>
				<div class="item-category one_category">
					<strong class="one_category_label"><?php echo Text::_('JCATEGORY'); ?>:</strong>
					<?php
					$categoryNames = [];
					foreach ($categories as $category) {
						$categoryNames[] = '<span class="one_category_name">' . $this->escape($category->title) . '</span>';
					}
					echo implode(', ', $categoryNames);
					?>
				</div>
			<?php endif; ?>
		<?php endif; ?>

		<?php if ($params->get('show_create_date', 0)) : ?>
			<div class="item-date one_date">
				<strong class="one_date_label"><?php echo Text::_('JDATE'); ?>:</strong>
				<span class="one_date_value"><?php echo HTMLHelper::_('date', $item->created, Text::_('DATE_FORMAT_LC3')); ?></span>
			</div>
		<?php endif; ?>
	</div>

	<!-- Two Column Layout: Content Left, Sidebar Right -->
	<div class="row g-4 one_item_layout">
		<!-- Left Column: Slideshow, Text, etc. -->
		<div class="col-12 <?php echo $renderSidebar ? 'col-lg-' . (int) $mainWidth : ''; ?> one_item_main">

			<?php
			$showMapUnderIntro = $hasMap && ($mapPositionItem === 'under_intro');
			if ($showMapUnderIntro) {
				echo LayoutHelper::render('form.map', ['item' => $item, 'view' => $this, 'height' => 400], $layoutBase);
			}
			?>

			<?php if ($params->get('show_image', 1) && !empty($allImages)) : ?>
				<div class="item-image-slider mb-4 one_image_slider">
					<!-- Main Image Display -->
					<div class="slider-main-image mb-3 position-relative one_main_image_container" style="min-height: 400px; max-height: 600px; width: 100%; overflow: hidden; border: 1px solid #ddd; border-radius: 4px; background: #f0f0f0;">
						<!-- Navigation Arrows -->
						<?php if (count($allImages) > 1) : ?>
							<button type="button" class="slider-nav-btn slider-nav-prev one_nav_prev" aria-label="<?php echo Text::_('JPREVIOUS'); ?>" title="<?php echo Text::_('JPREVIOUS'); ?>">
								<span aria-hidden="true" class="one_nav_prev_icon">‹</span>
							</button>
							<button type="button" class="slider-nav-btn slider-nav-next one_nav_next" aria-label="<?php echo Text::_('JNEXT'); ?>" title="<?php echo Text::_('JNEXT'); ?>">
								<span aria-hidden="true" class="one_nav_next_icon">›</span>
							</button>
						<?php endif; ?>
						
						<img id="onecore-main-image" 
							src="<?php echo htmlspecialchars(Uri::root() . ltrim($allImages[0], '/'), ENT_QUOTES, 'UTF-8'); ?>" 
							alt="<?php echo $this->escape($item->title); ?>" 
							class="img-fluid w-100 h-100 main-image-active one_main_image" 
							style="height: 100%; width: 100%; object-fit: cover; transition: transform 0.6s ease-in-out, opacity 0.6s ease-in-out; display: block;" />
						<img id="onecore-main-image-next" 
							src="" 
							alt="" 
							class="img-fluid w-100 h-100 main-image-next d-none one_main_image_next" 
							style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; object-fit: cover; opacity: 0; transform: translateX(0); transition: transform 0.6s ease-in-out, opacity 0.6s ease-in-out; display: block;" />
					</div>

					<!-- Thumbnails -->
					<?php if (count($allImages) > 1) : ?>
						<div class="slider-thumbnails d-flex flex-wrap gap-2 justify-content-center one_thumbnails">
							<?php foreach ($allImages as $index => $imagePath) : ?>
								<?php
								$imageUrl = Uri::root() . ltrim($imagePath, '/');
								$isActive = $index === 0 ? 'active' : '';
								?>
								<div class="thumbnail-item one_thumbnail_item">
									<img src="<?php echo htmlspecialchars($imageUrl, ENT_QUOTES, 'UTF-8'); ?>" 
										alt="<?php echo $this->escape($item->title . ' - ' . ($index + 1)); ?>" 
										class="thumbnail-img <?php echo $isActive; ?> one_thumbnail_img" 
										data-main-src="<?php echo htmlspecialchars($imageUrl, ENT_QUOTES, 'UTF-8'); ?>"
										style="width: 100px; height: 100px; object-fit: cover; cursor: pointer; border: 2px solid <?php echo $index === 0 ? '#007bff' : '#ddd'; ?>; border-radius: 4px; transition: border-color 0.3s;" />
								</div>
							<?php endforeach; ?>
						</div>
					<?php endif; ?>
				</div>
			<?php endif; ?>

			<?php if ($item->fulltext) : ?>
				<div class="item-fulltext one_fulltext">
					<?php echo HTMLHelper::_('content.prepare', $item->fulltext, '', 'com_onecore.item'); ?>
				</div>

				<?php if (!empty($item->video_link)) : ?>
					<?php
					$videoUrl = trim((string) $item->video_link);
					$isHttps = (strpos($videoUrl, 'https://') === 0);
					if ($isHttps) :
					?>
						<div class="onecore-video-link mt-3 mb-3">
							<strong class="d-block mb-1"><?php echo Text::_('COM_ONECORE_VIDEO_LINK'); ?>:</strong>
							<a href="<?php echo $this->escape($videoUrl); ?>" target="_blank" rel="noopener noreferrer" class="onecore-video-link-url"><?php echo $this->escape($videoUrl); ?></a>
						</div>
					<?php endif; ?>
				<?php endif; ?>

				<?php if (!empty($item->events)) : ?>
					<?php
					// Get events columns from component options (default: 2)
					$eventsColumns = (int) $params->get('events_columns', 2);
					if ($eventsColumns < 1 || $eventsColumns > 4) {
						$eventsColumns = 2;
					}
					// Calculate Bootstrap column classes based on number of columns
					// 1 column = col-12
					// 2 columns = col-12 col-md-6
					// 3 columns = col-12 col-md-6 col-lg-4
					// 4 columns = col-12 col-md-6 col-lg-3
					$columnClasses = 'col-12';
					if ($eventsColumns >= 2) {
						$columnClasses .= ' col-md-6';
					}
					if ($eventsColumns >= 3) {
						$columnClasses .= ' col-lg-4';
					} elseif ($eventsColumns == 4) {
						$columnClasses .= ' col-lg-3';
					}
					?>
					<div class="onecore-connected-events mt-4 mb-4">
						<h3 class="mb-3"><?php echo Text::_('COM_ONECORE_CONNECTED_EVENTS'); ?></h3>
						<div class="row g-3">
							<?php foreach ($item->events as $event) : ?>
								<?php
								$eventSlug = $event->alias ? ($event->id . ':' . $event->alias) : $event->id;
								$eventStart = HTMLHelper::_('date', $event->event_start, Text::_('DATE_FORMAT_LC3'));
								$eventEnd = !empty($event->event_end) ? HTMLHelper::_('date', $event->event_end, Text::_('DATE_FORMAT_LC3')) : '';
								
								// Get event images (already parsed in model)
								$eventImages = !empty($event->all_images) ? $event->all_images : [];
								$hasEventImage = !empty($eventImages);
								$eventImageUrl = $hasEventImage ? Uri::root() . ltrim($eventImages[0], '/') : '';
								?>
								<div class="<?php echo $columnClasses; ?>">
									<div class="card h-100 onecore-event-card">
										<?php if ($hasEventImage) : ?>
											<div class="position-relative">
												<img src="<?php echo htmlspecialchars($eventImageUrl, ENT_QUOTES, 'UTF-8'); ?>" 
													alt="<?php echo $this->escape($event->title); ?>" 
													class="card-img-top" 
													style="height: 200px; object-fit: cover;" />
												<?php if (!empty($event->categories)) : ?>
													<div class="position-absolute top-0 start-0 m-2">
														<?php foreach ($event->categories as $category) : ?>
															<span class="badge bg-primary bg-opacity-75 mb-1 d-block"><?php echo $this->escape($category->title); ?></span>
														<?php endforeach; ?>
													</div>
												<?php endif; ?>
											</div>
										<?php endif; ?>
										<div class="card-body">
											<h4 class="card-title">
												<?php echo $this->escape($event->title); ?>
											</h4>
											<div class="card-text">
												<?php if ($eventStart || $eventEnd) : ?>
													<div class="mb-2 onecore-event-card-dates">
														<?php if ($eventStart) : ?>
															<div class="small text-muted"><?php echo Text::_('COM_ONECORE_EVENT_START'); ?></div>
															<div class="fw-bold"><?php echo $eventStart; ?></div>
														<?php endif; ?>
														<?php if ($eventStart && $eventEnd) : ?>
															<div class="text-muted my-1">—</div>
														<?php endif; ?>
														<?php if ($eventEnd) : ?>
															<div class="small text-muted"><?php echo Text::_('COM_ONECORE_EVENT_END'); ?></div>
															<div class="fw-bold"><?php echo $eventEnd; ?></div>
														<?php endif; ?>
													</div>
												<?php endif; ?>
												<?php if (!empty($event->description)) : ?>
													<div class="event-description">
														<?php echo HTMLHelper::_('content.prepare', substr(strip_tags($event->description), 0, 150)); ?>
														<?php if (strlen(strip_tags($event->description)) > 150) : ?>...<?php endif; ?>
													</div>
												<?php endif; ?>
												<?php if (!empty($event->customfields_card)) : ?>
													<?php foreach ($event->customfields_card as $group) : ?>
														<div class="mt-2 onecore-event-card-customfields">
															<?php if (!empty($group->show_title) && !empty($group->title)) : ?>
																<strong class="small"><?php echo htmlspecialchars((string) $group->title, ENT_QUOTES, 'UTF-8'); ?>:</strong>
															<?php endif; ?>
															<?php if (!empty($group->fields)) : ?>
																<div class="small">
																	<?php foreach ($group->fields as $cf) : ?>
																		<?php if (!empty($cf->display_label)) : ?>
																			<span class="fw-bold"><?php echo htmlspecialchars((string) $cf->title, ENT_QUOTES, 'UTF-8'); ?>:</span>
																		<?php endif; ?>
																		<span><?php echo htmlspecialchars((string) substr($cf->value, 0, 50), ENT_QUOTES, 'UTF-8'); ?><?php echo strlen($cf->value) > 50 ? '...' : ''; ?></span>
																	<?php endforeach; ?>
																</div>
															<?php endif; ?>
														</div>
													<?php endforeach; ?>
												<?php endif; ?>
											</div>
										</div>
										<div class="card-footer bg-transparent border-top-0">
											<button type="button" 
												class="btn btn-primary btn-sm onecore-event-modal-btn" 
												data-bs-toggle="modal" 
												data-bs-target="#onecoreEventModal<?php echo $event->id; ?>"
												data-event-id="<?php echo $event->id; ?>">
												<?php echo Text::_('COM_ONECORE_READ_MORE'); ?>
											</button>
										</div>
									</div>
								</div>

								<!-- Event Modal -->
								<div class="modal fade" id="onecoreEventModal<?php echo $event->id; ?>" tabindex="-1" aria-labelledby="onecoreEventModalLabel<?php echo $event->id; ?>" aria-hidden="true">
									<div class="modal-dialog modal-lg modal-dialog-scrollable">
										<div class="modal-content">
											<div class="modal-header">
												<h2 class="modal-title" id="onecoreEventModalLabel<?php echo $event->id; ?>">
													<?php echo $this->escape($event->title); ?>
												</h2>
												<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="<?php echo Text::_('COM_ONECORE_CLOSE'); ?>"></button>
											</div>
											<div class="modal-body">
												<?php 
												// Get all images for slideshow
												$eventAllImages = !empty($event->all_images) ? $event->all_images : [];
												$hasEventImages = !empty($eventAllImages);
												?>
												
												<?php if ($hasEventImages) : ?>
													<div class="mb-4 onecore-event-modal-slideshow">
														<div id="eventModalCarousel<?php echo $event->id; ?>" class="carousel slide" data-bs-ride="carousel">
															<?php if (count($eventAllImages) > 1) : ?>
																<div class="carousel-indicators">
																	<?php foreach ($eventAllImages as $idx => $img) : ?>
																		<button type="button" data-bs-target="#eventModalCarousel<?php echo $event->id; ?>" data-bs-slide-to="<?php echo $idx; ?>" <?php echo $idx === 0 ? 'class="active" aria-current="true"' : ''; ?> aria-label="Slide <?php echo $idx + 1; ?>"></button>
																	<?php endforeach; ?>
																</div>
															<?php endif; ?>
															<div class="carousel-inner">
																<?php foreach ($eventAllImages as $idx => $imgPath) : ?>
																	<?php $imgUrl = Uri::root() . ltrim($imgPath, '/'); ?>
																	<div class="carousel-item <?php echo $idx === 0 ? 'active' : ''; ?>" style="height: 400px; overflow: hidden;">
																		<img src="<?php echo htmlspecialchars($imgUrl, ENT_QUOTES, 'UTF-8'); ?>" 
																			alt="<?php echo $this->escape($event->title . ' - ' . ($idx + 1)); ?>" 
																			class="d-block w-100 h-100" 
																			style="height: 100%; width: 100%; object-fit: cover;" />
																	</div>
																<?php endforeach; ?>
															</div>
															<?php if (count($eventAllImages) > 1) : ?>
																<button class="carousel-control-prev" type="button" data-bs-target="#eventModalCarousel<?php echo $event->id; ?>" data-bs-slide="prev">
																	<span class="carousel-control-prev-icon" aria-hidden="true"></span>
																	<span class="visually-hidden"><?php echo Text::_('JPREVIOUS'); ?></span>
																</button>
																<button class="carousel-control-next" type="button" data-bs-target="#eventModalCarousel<?php echo $event->id; ?>" data-bs-slide="next">
																	<span class="carousel-control-next-icon" aria-hidden="true"></span>
																	<span class="visually-hidden"><?php echo Text::_('JNEXT'); ?></span>
																</button>
															<?php endif; ?>
														</div>
													</div>
												<?php endif; ?>
												
												<?php if (!empty($event->categories)) : ?>
													<div class="mb-3">
														<strong><?php echo Text::_('JCATEGORY'); ?>:</strong>
														<div class="mt-1">
															<?php
															$categoryNames = [];
															foreach ($event->categories as $category) {
																$categoryNames[] = '<span class="badge bg-primary">' . $this->escape($category->title) . '</span>';
															}
															echo implode(' ', $categoryNames);
															?>
														</div>
													</div>
												<?php endif; ?>

												<?php if ($eventStart || $eventEnd) : ?>
													<div class="mb-4 onecore-event-dates">
														<div class="d-flex flex-wrap gap-3 align-items-center">
															<?php if ($eventStart) : ?>
																<div class="onecore-event-date-item">
																	<div class="small text-muted mb-1"><?php echo Text::_('COM_ONECORE_EVENT_START'); ?></div>
																	<div class="fw-bold fs-5"><?php echo $eventStart; ?></div>
																</div>
															<?php endif; ?>
															<?php if ($eventStart && $eventEnd) : ?>
																<div class="text-muted">—</div>
															<?php endif; ?>
															<?php if ($eventEnd) : ?>
																<div class="onecore-event-date-item">
																	<div class="small text-muted mb-1"><?php echo Text::_('COM_ONECORE_EVENT_END'); ?></div>
																	<div class="fw-bold fs-5"><?php echo $eventEnd; ?></div>
																</div>
															<?php endif; ?>
														</div>
													</div>
												<?php endif; ?>

												<?php if (!empty($event->address) || !empty($event->address_street) || !empty($event->address_city)) : ?>
													<div class="mb-3">
														<strong><?php echo Text::_('COM_ONECORE_EVENT_LOCATION'); ?>:</strong>
														<div class="mt-1">
															<?php if (!empty($event->address)) : ?>
																<?php echo nl2br(htmlspecialchars($event->address, ENT_QUOTES, 'UTF-8')); ?>
															<?php else : ?>
																<?php
																$addressParts = array_filter([
																	$event->address_street ?? '',
																	$event->address_street_number ?? '',
																	$event->address_postal_code ?? '',
																	$event->address_city ?? '',
																	$event->address_country ?? ''
																]);
																if (!empty($addressParts)) {
																	echo nl2br(htmlspecialchars(implode(' ', $addressParts), ENT_QUOTES, 'UTF-8'));
																}
																?>
															<?php endif; ?>
														</div>
													</div>
												<?php endif; ?>

												<?php if (!empty($event->description)) : ?>
													<div class="mb-3">
														<strong><?php echo Text::_('COM_ONECORE_EVENT_DESCRIPTION'); ?>:</strong>
														<div class="mt-2">
															<?php echo HTMLHelper::_('content.prepare', $event->description); ?>
														</div>
													</div>
												<?php endif; ?>

												<?php if (!empty($event->customfields_modal)) : ?>
													<?php foreach ($event->customfields_modal as $group) : ?>
														<div class="mb-3 onecore-event-customfield-group">
															<?php if (!empty($group->show_title) && !empty($group->title)) : ?>
																<h3 class="fw-bold mb-2"><?php echo htmlspecialchars((string) $group->title, ENT_QUOTES, 'UTF-8'); ?></h3>
															<?php endif; ?>
															<?php if (!empty($group->show_description) && !empty($group->description)) : ?>
																<div class="mb-2 small text-muted"><?php echo HTMLHelper::_('content.prepare', $group->description, '', 'com_onecore.customfieldgroup'); ?></div>
															<?php endif; ?>
															<?php if (!empty($group->fields)) : ?>
																<div class="onecore-event-customfields">
																	<?php foreach ($group->fields as $cf) : ?>
																		<div class="mb-2 onecore-event-customfield">
																			<?php if (!empty($cf->display_label)) : ?>
																				<?php if (($cf->label_position ?? 'next') === 'over') : ?>
																					<div class="fw-bold small"><?php echo htmlspecialchars((string) $cf->title, ENT_QUOTES, 'UTF-8'); ?></div>
																					<div><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></div>
																				<?php else : ?>
																					<span class="fw-bold"><?php echo htmlspecialchars((string) $cf->title, ENT_QUOTES, 'UTF-8'); ?>:</span>
																					<span><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></span>
																				<?php endif; ?>
																			<?php else : ?>
																				<span><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></span>
																			<?php endif; ?>
																		</div>
																	<?php endforeach; ?>
																</div>
															<?php endif; ?>
														</div>
													<?php endforeach; ?>
												<?php endif; ?>
											</div>
											<div class="modal-footer">
												<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
													<?php echo Text::_('COM_ONECORE_CLOSE'); ?>
												</button>
											</div>
										</div>
									</div>
								</div>
							<?php endforeach; ?>
						</div>
					</div>
				<?php endif; ?>

				<?php if (!empty($item->customfields_under_intro)) : ?>
					<?php foreach ($item->customfields_under_intro as $group) : ?>
						<div class="one_customfield_group one_customfield_group--under-intro mb-3">
							<?php if (!empty($group->show_title) && !empty($group->title)) : ?>
								<h3 class="one_customfield_group_title"><?php echo htmlspecialchars((string) $group->title, ENT_QUOTES, 'UTF-8'); ?></h3>
							<?php endif; ?>
							<?php if (!empty($group->show_description) && !empty($group->description)) : ?>
								<div class="one_customfield_group_description mb-2"><?php echo HTMLHelper::_('content.prepare', $group->description, '', 'com_onecore.customfieldgroup'); ?></div>
							<?php endif; ?>
							<?php if (!empty($group->fields)) : ?>
								<div class="one_customfields one_customfields--under-intro">
									<?php foreach ($group->fields as $cf) : ?>
										<div class="one_customfield">
											<?php if (!empty($cf->display_label)) : ?>
												<?php if (($cf->label_position ?? 'next') === 'over') : ?>
													<div class="one_customfield_label"><?php echo htmlspecialchars((string) $cf->title, ENT_QUOTES, 'UTF-8'); ?></div>
													<div class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></div>
												<?php else : ?>
													<span class="one_customfield_label"><?php echo htmlspecialchars((string) $cf->title, ENT_QUOTES, 'UTF-8'); ?>:</span>
													<span class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></span>
												<?php endif; ?>
											<?php else : ?>
												<span class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></span>
											<?php endif; ?>
										</div>
									<?php endforeach; ?>
								</div>
							<?php endif; ?>
						</div>
					<?php endforeach; ?>
				<?php endif; ?>
			<?php endif; ?>

			<?php if ($item->introtext && empty($item->fulltext)) : ?>
				<div class="item-introtext one_introtext">
					<?php echo HTMLHelper::_('content.prepare', $item->introtext, '', 'com_onecore.item'); ?>
				</div>
				<?php if (!empty($item->customfields_under_intro)) : ?>
					<?php foreach ($item->customfields_under_intro as $group) : ?>
						<div class="one_customfield_group one_customfield_group--under-intro mb-3">
							<?php if (!empty($group->show_title) && !empty($group->title)) : ?>
								<h3 class="one_customfield_group_title"><?php echo htmlspecialchars((string) $group->title, ENT_QUOTES, 'UTF-8'); ?></h3>
							<?php endif; ?>
							<?php if (!empty($group->show_description) && !empty($group->description)) : ?>
								<div class="one_customfield_group_description mb-2"><?php echo HTMLHelper::_('content.prepare', $group->description, '', 'com_onecore.customfieldgroup'); ?></div>
							<?php endif; ?>
							<?php if (!empty($group->fields)) : ?>
								<div class="one_customfields one_customfields--under-intro">
									<?php foreach ($group->fields as $cf) : ?>
										<div class="one_customfield">
											<?php if (!empty($cf->display_label)) : ?>
												<?php if (($cf->label_position ?? 'next') === 'over') : ?>
													<div class="one_customfield_label"><?php echo htmlspecialchars((string) $cf->title, ENT_QUOTES, 'UTF-8'); ?></div>
													<div class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></div>
												<?php else : ?>
													<span class="one_customfield_label"><?php echo htmlspecialchars((string) $cf->title, ENT_QUOTES, 'UTF-8'); ?>:</span>
													<span class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></span>
												<?php endif; ?>
											<?php else : ?>
												<span class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></span>
											<?php endif; ?>
										</div>
									<?php endforeach; ?>
								</div>
							<?php endif; ?>
						</div>
					<?php endforeach; ?>
				<?php endif; ?>
			<?php endif; ?>

			<?php if ($hasContactForm && $blockContactPosition === 'content') : ?>
				<?php echo LayoutHelper::render('form.contact', [
					'item' => $item,
					'view' => $this,
					'formId' => 'onecore-contact-form',
					'size' => 'full',
				], $layoutBase); ?>
			<?php endif; ?>
		</div>

		<?php if ($renderSidebar) : ?>
			<div class="col-12 col-lg-<?php echo (int) $sidebarWidth; ?> one_item_sidebar">
				<aside class="one_item_sidebar_inner">
					<?php foreach ($sidebarBlocks as $block) : ?>
						<?php
						switch ($block['id']) {
							case 'map':
								echo LayoutHelper::render('form.map', ['item' => $item, 'view' => $this, 'height' => 300], $layoutBase);
								break;
							case 'address':
								echo LayoutHelper::render('form.address', ['item' => $item, 'view' => $this], $layoutBase);
								break;
							case 'customfields':
								echo LayoutHelper::render('form.customfields', [
									'groups' => $item->customfields_sidebar ?? [],
									'view' => $this,
									'layout' => 'sidebar',
								], $layoutBase);
								break;
							case 'contact':
								echo LayoutHelper::render('form.contact', [
									'item' => $item,
									'view' => $this,
									'formId' => 'onecore-contact-form-sidebar',
									'size' => 'small',
								], $layoutBase);
								break;
						}
						?>
					<?php endforeach; ?>

					<?php if ($hasSidebarModules) : ?>
						<?php foreach ($sidebarModules as $mod) : ?>
							<?php
							$moduleHtml = ModuleHelper::renderModule($mod, ['contentOnly' => true]);
							if (trim((string) $moduleHtml) === '') {
								continue;
							}
							?>
							<div class="one_sidebar_module card mb-4">
								<div class="card-body">
									<?php if (!empty($mod->showtitle)) : ?>
										<h3 class="card-title h5 mb-3"><?php echo $this->escape($mod->title); ?></h3>
									<?php endif; ?>
									<div class="one_sidebar_module_content">
										<?php echo $moduleHtml; ?>
									</div>
								</div>
							</div>
						<?php endforeach; ?>
					<?php elseif (empty($sidebarBlocks) && $user->authorise('core.admin')) : ?>
						<div class="alert alert-info">
							<strong>OneCore sidebar enabled</strong><br />
							No modules in position <code><?php echo $this->escape($sidebarPosition); ?></code> and no Item blocks (map, address, custom fields, contact) to display.
						</div>
					<?php endif; ?>
				</aside>
			</div>
		<?php endif; ?>
	</div>
</div>

<style>
.one_image_slider,
.item-image-slider {
	background: #f8f9fa;
	padding: 20px;
	border-radius: 8px;
}
.one_main_image_container,
.slider-main-image {
	overflow: hidden;
	position: relative;
	width: 100%;
}
.one_main_image_container img,
.slider-main-image img {
	display: block;
}
.one_main_image.main-image-active,
.main-image-active {
	opacity: 1 !important;
	position: relative;
	z-index: 1;
	transform: translateX(0);
}
.one_main_image_next.main-image-next,
.main-image-next {
	opacity: 0 !important;
	position: absolute;
	top: 0;
	left: 0;
	z-index: 2;
}
.one_main_image_next.main-image-next.slide-in-left,
.main-image-next.slide-in-left {
	transform: translateX(-100%);
}
.one_main_image_next.main-image-next.slide-in-right,
.main-image-next.slide-in-right {
	transform: translateX(100%);
}
.one_main_image.main-image-active.slide-out-left,
.main-image-active.slide-out-left {
	transform: translateX(-100%);
	opacity: 0 !important;
}
.one_main_image.main-image-active.slide-out-right,
.main-image-active.slide-out-right {
	transform: translateX(100%);
	opacity: 0 !important;
}
.one_nav_prev,
.one_nav_next,
.slider-nav-btn {
	position: absolute;
	top: 50%;
	transform: translateY(-50%);
	z-index: 10;
	background: rgba(0, 0, 0, 0.6);
	color: #fff;
	border: none;
	border-radius: 50%;
	width: 50px;
	height: 50px;
	cursor: pointer;
	display: flex;
	align-items: center;
	justify-content: center;
	font-size: 24px;
	transition: all 0.3s ease;
	opacity: 0.7;
}
.one_nav_prev:hover,
.one_nav_next:hover,
.slider-nav-btn:hover {
	background: rgba(0, 0, 0, 0.9);
	opacity: 1;
	transform: translateY(-50%) scale(1.1);
}
.one_nav_prev:active,
.one_nav_next:active,
.slider-nav-btn:active {
	transform: translateY(-50%) scale(0.95);
}
.one_nav_prev:disabled,
.one_nav_next:disabled,
.slider-nav-btn:disabled {
	opacity: 0.3;
	cursor: not-allowed;
}
.one_nav_prev:disabled:hover,
.one_nav_next:disabled:hover,
.slider-nav-btn:disabled:hover {
	background: rgba(0, 0, 0, 0.6);
	transform: translateY(-50%);
}
.one_nav_prev,
.slider-nav-prev {
	left: 15px;
}
.one_nav_next,
.slider-nav-next {
	right: 15px;
}
.one_nav_prev_icon,
.one_nav_next_icon,
.slider-nav-btn span {
	font-size: 32px;
	line-height: 1;
	font-weight: bold;
	display: block;
}
.one_thumbnails,
.slider-thumbnails {
	display: flex !important;
	flex-wrap: wrap;
	gap: 0.5rem;
	justify-content: center;
	align-items: center;
}
.one_thumbnail_item,
.thumbnail-item {
	display: inline-block;
	flex-shrink: 0;
}
.one_thumbnail_img,
.thumbnail-img {
	transition: all 0.3s ease;
	display: block;
}
.one_thumbnail_img:hover,
.thumbnail-img:hover {
	border-color: #007bff !important;
	opacity: 0.8;
	transform: scale(1.05);
}
.one_thumbnail_img.active,
.thumbnail-img.active {
	border-color: #007bff !important;
	box-shadow: 0 0 5px rgba(0, 123, 255, 0.5);
}
.one_thumbnail_img.loading,
.thumbnail-img.loading {
	opacity: 0.5;
	cursor: wait;
}
</style>

<script>
(function($) {
	$(document).ready(function() {
		var $mainImage = $('#onecore-main-image');
		var $nextImage = $('#onecore-main-image-next');
		var $thumbnails = $('.thumbnail-img');
		var $prevBtn = $('.slider-nav-prev');
		var $nextBtn = $('.slider-nav-next');
		var isAnimating = false;
		var currentIndex = 0;
		var totalImages = $thumbnails.length;

		// Preload all images
		var imagesToPreload = [];
		$thumbnails.each(function() {
			var src = $(this).data('main-src');
			if (src) {
				var img = new Image();
				img.src = src;
				imagesToPreload.push(img);
			}
		});

		// Function to update navigation buttons state
		function updateNavigationButtons() {
			$prevBtn.prop('disabled', currentIndex === 0 || isAnimating);
			$nextBtn.prop('disabled', currentIndex === totalImages - 1 || isAnimating);
		}

		// Function to change image with slide animation
		function changeImage(newIndex, direction) {
			if (isAnimating || newIndex === currentIndex || newIndex < 0 || newIndex >= totalImages) {
				return;
			}

			isAnimating = true;
			var $targetThumb = $thumbnails.eq(newIndex);
			var mainImageSrc = $targetThumb.data('main-src');
			var currentSrc = $mainImage.attr('src');

			// If clicking on the same image, do nothing
			if (mainImageSrc === currentSrc) {
				isAnimating = false;
				return;
			}

			$targetThumb.addClass('loading');

			// Remove previous event handlers
			$nextImage.off('load error');

			// Determine slide direction
			var slideClassIn = direction === 'prev' ? 'slide-in-left' : 'slide-in-right';
			var slideClassOut = direction === 'prev' ? 'slide-out-right' : 'slide-out-left';

			// Set next image source
			$nextImage.attr('src', mainImageSrc);
			$nextImage.attr('alt', $targetThumb.attr('alt'));
			$nextImage.removeClass('d-none slide-in-left slide-in-right');
			$nextImage.addClass(slideClassIn);
			$nextImage.css('opacity', '0');

			// Function to handle image loaded
			function handleImageLoaded() {
				// Slide out current image
				$mainImage.addClass(slideClassOut);
				
				setTimeout(function() {
					// Slide in next image
					$nextImage.css('opacity', '1');
					
					setTimeout(function() {
						// Swap images
						$mainImage.attr('src', mainImageSrc);
						$mainImage.attr('alt', $targetThumb.attr('alt'));
						$mainImage.removeClass('slide-out-left slide-out-right');
						$mainImage.css('opacity', '1');
						$mainImage.css('transform', 'translateX(0)');
						
						// Reset next image
						$nextImage.attr('src', '');
						$nextImage.attr('alt', '');
						$nextImage.removeClass('slide-in-left slide-in-right');
						$nextImage.css('opacity', '0');
						$nextImage.css('transform', 'translateX(0)');
						$nextImage.addClass('d-none');
						
						// Update active thumbnail
						$thumbnails.removeClass('active').css('border-color', '#ddd');
						$targetThumb.addClass('active').css('border-color', '#007bff');
						$targetThumb.removeClass('loading');
						
						currentIndex = newIndex;
						updateNavigationButtons();
						isAnimating = false;
					}, 600); // Wait for slide animation to complete
				}, 50);
			}

			// Wait for next image to load
			$nextImage.on('load', handleImageLoaded);

			// Handle image load error
			$nextImage.on('error', function() {
				$nextImage.attr('src', '');
				$nextImage.css('opacity', '0');
				$nextImage.addClass('d-none');
				$targetThumb.removeClass('loading');
				isAnimating = false;
				updateNavigationButtons();
			});

			// If image is already loaded (cached), trigger load event manually
			if ($nextImage[0].complete && $nextImage[0].naturalWidth > 0) {
				handleImageLoaded();
			} else {
				updateNavigationButtons();
			}
		}

		// Navigation button handlers
		$prevBtn.on('click', function() {
			if (!isAnimating && currentIndex > 0) {
				changeImage(currentIndex - 1, 'prev');
			}
		});

		$nextBtn.on('click', function() {
			if (!isAnimating && currentIndex < totalImages - 1) {
				changeImage(currentIndex + 1, 'next');
			}
		});

		// Handle thumbnail click with animation
		$thumbnails.on('click', function() {
			var clickedIndex = $thumbnails.index(this);
			var direction = clickedIndex > currentIndex ? 'next' : 'prev';
			changeImage(clickedIndex, direction);
		});

		// Keyboard navigation
		$(document).on('keydown', function(e) {
			if (e.target.tagName === 'INPUT' || e.target.tagName === 'TEXTAREA') {
				return;
			}
			
			if (e.key === 'ArrowLeft' && !isAnimating && currentIndex > 0) {
				changeImage(currentIndex - 1, 'prev');
			} else if (e.key === 'ArrowRight' && !isAnimating && currentIndex < totalImages - 1) {
				changeImage(currentIndex + 1, 'next');
			}
		});

		// Initialize navigation buttons state
		updateNavigationButtons();
	});
})(jQuery);
</script>

<?php
// Load Leaflet.js for maps
$wa = $this->getDocument()->getWebAssetManager();
$wa->registerAndUseStyle('leaflet', 'https://unpkg.com/leaflet@1.9.4/dist/leaflet.css', [], ['rel' => 'stylesheet']);
$wa->registerAndUseScript('leaflet', 'https://unpkg.com/leaflet@1.9.4/dist/leaflet.js', [], ['defer' => true]);

$defaultZoom = (int) $this->params->get('map_default_zoom', 13);
$document = \Joomla\CMS\Factory::getDocument();
$document->addScriptDeclaration("
(function() {
	'use strict';
	
	var defaultZoom = " . $defaultZoom . ";
	
	function initMaps() {
		if (typeof L === 'undefined') {
			setTimeout(initMaps, 100);
			return;
		}
		
		var mapContainers = document.querySelectorAll('.onecore-map-container');
		mapContainers.forEach(function(container) {
			if (container.dataset.initialized) return;
			container.dataset.initialized = 'true';
			
			var lat = parseFloat(container.getAttribute('data-lat'));
			var lng = parseFloat(container.getAttribute('data-lng'));
			var title = container.getAttribute('data-title') || '';
			
			if (isNaN(lat) || isNaN(lng)) return;
			
			var map = L.map(container).setView([lat, lng], defaultZoom);
			
		L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
			attribution: '&copy; <a href=\"https://www.openstreetmap.org/copyright\">OpenStreetMap</a> contributors',
			maxZoom: 19
		}).addTo(map);
		
		// Custom marker icon (128x128 square)
		var customIcon = L.icon({
			iconUrl: '" . \Joomla\CMS\Uri\Uri::root() . "components/com_onecore/assets/images/marker.png?v=" . filemtime(JPATH_ROOT . '/components/com_onecore/assets/images/marker.png') . "',
			iconSize: [48, 48],
			iconAnchor: [24, 48],
			popupAnchor: [0, -48]
		});
		
		var marker = L.marker([lat, lng], {icon: customIcon}).addTo(map);
		if (title) {
			marker.bindPopup(title);
		}
	});
}
	
	document.addEventListener('DOMContentLoaded', initMaps);
	if (document.readyState === 'complete' || document.readyState === 'interactive') {
		setTimeout(initMaps, 100);
	}
})();
");

// Contact form validation
$document->addScriptDeclaration("
(function() {
	'use strict';
	
	var forms = document.querySelectorAll('#onecore-contact-form, #onecore-contact-form-sidebar');
	
	Array.prototype.slice.call(forms).forEach(function(form) {
		form.addEventListener('submit', function(event) {
			if (!form.checkValidity()) {
				event.preventDefault();
				event.stopPropagation();
			}
			form.classList.add('was-validated');
		}, false);
	});
})();
");

// Initialize Bootstrap modals for events
$document->addScriptDeclaration("
(function() {
	'use strict';
	
	function initEventModals() {
		// Initialize all event modals using Bootstrap 5
		var modalButtons = document.querySelectorAll('.onecore-event-modal-btn');
		
		modalButtons.forEach(function(button) {
			button.addEventListener('click', function(e) {
				e.preventDefault();
				var targetId = this.getAttribute('data-bs-target');
				if (targetId) {
					var modalElement = document.querySelector(targetId);
					if (modalElement) {
						// Try Bootstrap 5 Modal API
						if (typeof bootstrap !== 'undefined' && bootstrap.Modal) {
							var modalInstance = bootstrap.Modal.getInstance(modalElement);
							if (!modalInstance) {
								modalInstance = new bootstrap.Modal(modalElement);
							}
							modalInstance.show();
						} 
						// Try Joomla Modal API
						else if (typeof Joomla !== 'undefined' && Joomla.initialiseModal) {
							Joomla.initialiseModal(modalElement);
							if (modalElement.open) {
								modalElement.open();
							} else {
								modalElement.classList.add('show');
								modalElement.style.display = 'block';
							}
						} 
						// Fallback: manual modal display
						else {
							modalElement.classList.add('show');
							modalElement.style.display = 'block';
							document.body.classList.add('modal-open');
							var backdrop = document.createElement('div');
							backdrop.className = 'modal-backdrop fade show';
							document.body.appendChild(backdrop);
							
							// Close handlers
							var closeModal = function() {
								modalElement.classList.remove('show');
								modalElement.style.display = 'none';
								document.body.classList.remove('modal-open');
								if (backdrop.parentNode) {
									backdrop.parentNode.removeChild(backdrop);
								}
							};
							
							var closeButtons = modalElement.querySelectorAll('[data-bs-dismiss=\"modal\"], .btn-close');
							closeButtons.forEach(function(closeBtn) {
								closeBtn.addEventListener('click', closeModal);
							});
							
							backdrop.addEventListener('click', closeModal);
							
							// Close on ESC key
							document.addEventListener('keydown', function escHandler(e) {
								if (e.key === 'Escape' && modalElement.classList.contains('show')) {
									closeModal();
									document.removeEventListener('keydown', escHandler);
								}
							});
						}
					}
				}
			});
		});
	}
	
	// Initialize when DOM is ready
	if (document.readyState === 'loading') {
		document.addEventListener('DOMContentLoaded', initEventModals);
	} else {
		initEventModals();
	}
})();

// Hide template sidebars with JavaScript (backup method)
(function() {
	'use strict';
	
	// Check if element has OneCore classes
	function isOneCoreElement(el) {
		const classList = el.className || '';
		return classList.includes('one_') || 
		       classList.includes('onecore-') ||
		       el.closest('[class*=\"one_\"]') !== null ||
		       el.closest('[class*=\"onecore-\"]') !== null;
	}
	
	function hideSidebars() {
		// Check if OneCore sidebar is active
		const hasOneCoreSidebar = document.body.classList.contains('onecore-sidebar-active') ||
		                          document.querySelector('.one_item_sidebar') !== null;
		
		if (hasOneCoreSidebar) {
			console.log('OneCore: Sidebar active, not hiding template sidebars');
			return; // Don't hide anything if OneCore sidebar is present
		}
		
		const sidebarSelectors = [
			'.tm-sidebar',
			'.sidebar',
			'aside.sidebar',
			'.sidebar-left',
			'.sidebar-right',
			'#sidebar',
			'.page-sidebar',
			'.blog-sidebar',
			'.uk-width-1-4',
			'.uk-width-1-3',
			'.span3',
			'.span4',
			'.col-md-3',
			'.col-md-4',
			'.col-lg-3',
			'.col-lg-4'
		];
		
		sidebarSelectors.forEach(function(selector) {
			try {
				const elements = document.querySelectorAll(selector);
				elements.forEach(function(el) {
					// Don't hide if it's OneCore's element
					if (!isOneCoreElement(el)) {
						el.style.display = 'none';
					}
				});
			} catch(e) {
				console.log('OneCore: Could not hide ' + selector);
			}
		});
		
		// Expand main content to full width
		const mainSelectors = [
			'.tm-main',
			'.main-content',
			'.content-main',
			'main.main',
			'.uk-width-3-4',
			'.uk-width-2-3',
			'.span8',
			'.span9',
			'.col-md-8',
			'.col-md-9',
			'.col-lg-8',
			'.col-lg-9'
		];
		
		mainSelectors.forEach(function(selector) {
			try {
				const elements = document.querySelectorAll(selector);
				elements.forEach(function(el) {
					if (!isOneCoreElement(el)) {
						el.style.width = '100%';
						el.style.maxWidth = '100%';
						el.style.flex = '0 0 100%';
					}
				});
			} catch(e) {
				console.log('OneCore: Could not expand ' + selector);
			}
		});
	}
	
	// Run immediately and after DOM load
	hideSidebars();
	if (document.readyState === 'loading') {
		document.addEventListener('DOMContentLoaded', hideSidebars);
	}
	// Also run after a short delay to catch late-loading elements
	setTimeout(hideSidebars, 100);
})();
");
?>
