<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Comdev\Component\Onecore\Site\Helper\RouteHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

/** @var \Comdev\Component\Onecore\Site\View\Content\HtmlView $this */

// Get columns per row from URL parameter (default: 3)
$app = Factory::getApplication();
$columnsPerRow = $app->getInput()->getInt('columns', 3);

// Validate columns (only allow 2, 3, or 4)
if (!in_array($columnsPerRow, [2, 3, 4])) {
	$columnsPerRow = 3;
}

// Calculate Bootstrap column classes based on columns per row
// Bootstrap grid has 12 columns, so:
// 2 columns = col-md-6 (12/2=6)
// 3 columns = col-md-4 (12/3=4)
// 4 columns = col-md-3 (12/4=3)
$colClassMap = [
	2 => 'col-md-6',
	3 => 'col-md-4',
	4 => 'col-md-3',
];

$colClass = isset($colClassMap[$columnsPerRow]) ? $colClassMap[$columnsPerRow] : 'col-md-4';
$smColClass = 'col-sm-6'; // Always 2 columns on small screens

// Map data for top map (used by default.php init; also for data attributes when AJAX reload)
$gridMapItems = [];
$gridMapZoom = 13;
$gridHasMap = false;
$showMap = $this->params->get('show_map', 1);
$mapPositionItems = $this->params->get('map_position_items', 'top');
// Show only items from current page, not all items from database
$itemsForMap = $this->items ?? [];
if ($showMap && $mapPositionItems === 'top' && !empty($itemsForMap)) {
	foreach ($itemsForMap as $it) {
		if (!empty($it->latitude) && !empty($it->longitude)) {
			$gridHasMap = true;
			$gridMapItems[] = [
				'lat' => (float) $it->latitude,
				'lng' => (float) $it->longitude,
				'title' => $this->escape($it->title ?? ''),
				'url' => Route::_(RouteHelper::getItemRoute($it->id . ':' . ($it->alias ?? '')))
			];
		}
	}
	$gridMapZoom = (int) $this->params->get('map_default_zoom', 13);
}

// Function to limit text by words
if (!function_exists('limitWords')) {
	function limitWords($text, $limit = 30) {
		if (empty($text)) {
			return '';
		}
		
		$text = strip_tags($text);
		$words = explode(' ', $text);
		
		if (count($words) <= $limit) {
			return $text;
		}
		
		$words = array_slice($words, 0, $limit);
		return implode(' ', $words) . '...';
	}
}
?>
<div class="com-onecore-content content-grid one_container one_grid" id="onecore-content-grid">
	<?php if ($this->params->get('show_page_heading')) : ?>
		<div class="page-header one_header">
			<h1 class="one_page_heading"><?php echo $this->escape($this->params->get('page_heading')); ?></h1>
		</div>
	<?php endif; ?>

	<?php if (!empty($this->items)) : ?>
		<?php if ($gridHasMap) : ?>
			<div class="col-12 mb-4">
				<div class="onecore-map-container"
					 id="onecore-map-items-top"
					 style="height: 400px; border: 1px solid #ddd; border-radius: 4px;"
					 data-map-items="<?php echo htmlspecialchars(json_encode($gridMapItems), ENT_QUOTES, 'UTF-8'); ?>"
					 data-map-zoom="<?php echo (int) $gridMapZoom; ?>"></div>
			</div>
		<?php endif; ?>
		<div class="items-grid row g-3 one_grid_items" data-columns="<?php echo (int)$columnsPerRow; ?>">
			<?php foreach ($this->items as $item) : ?>
				<div class="<?php echo htmlspecialchars($colClass . ' ' . $smColClass, ENT_QUOTES, 'UTF-8'); ?> one_grid_col<?php echo !empty($item->featured) ? ' one_grid_col--featured' : ''; ?>">
					<div class="item-card card h-100 one_grid_card">
						<?php if ($this->params->get('show_image', 1)) : ?>
							<?php 
							$itemUrl = Route::_(RouteHelper::getItemRoute($item->id . ':' . $item->alias));
							$hasImage = !empty($item->image);
							?>
							<div class="item-image one_grid_image">
								<?php if ($this->params->get('linked_titles', 1)) : ?>
									<a href="<?php echo $itemUrl; ?>" title="<?php echo $this->escape($item->title); ?>" class="one_grid_image_link">
								<?php endif; ?>
								<?php if ($hasImage) : ?>
									<?php echo HTMLHelper::_('image', $item->image, $this->escape($item->title), [
										'class' => 'card-img-top one_grid_image_img',
										'loading' => 'lazy'
									]); ?>
								<?php else : ?>
									<div class="one_grid_image_placeholder card-img-top one_grid_image_img">
										<svg class="one_grid_placeholder_icon" width="100" height="100" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path d="M21 19V5C21 3.9 20.1 3 19 3H5C3.9 3 3 3.9 3 5V19C3 20.1 3.9 21 5 21H19C20.1 21 21 20.1 21 19ZM8.5 13.5L11 16.51L14.5 12L19 18H5L8.5 13.5Z" fill="currentColor"/>
										</svg>
										<span class="one_grid_placeholder_text"><?php echo Text::_('COM_ONECORE_NO_IMAGE') ?: 'No Image'; ?></span>
									</div>
								<?php endif; ?>
								<?php if ($this->params->get('linked_titles', 1)) : ?>
									</a>
								<?php endif; ?>
							</div>
						<?php endif; ?>

						<div class="card-body one_grid_body">
							<?php if ($this->params->get('show_title', 1)) : ?>
								<h3 class="card-title one_grid_title">
									<?php if ($this->params->get('linked_titles', 1)) : ?>
										<a href="<?php echo Route::_(RouteHelper::getItemRoute($item->id . ':' . $item->alias)); ?>" class="one_grid_title_link">
											<?php echo $this->escape($item->title); ?>
										</a>
									<?php else : ?>
										<span class="one_grid_title_text"><?php echo $this->escape($item->title); ?></span>
									<?php endif; ?>
								</h3>
							<?php endif; ?>

							<?php if (!empty($item->customfields_under_title)) : ?>
								<?php foreach ($item->customfields_under_title as $group) : ?>
									<div class="one_customfield_group one_customfield_group--under-title mb-2">
										<?php if (!empty($group->fields)) : ?>
											<div class="one_customfields one_customfields--under-title">
												<?php foreach ($group->fields as $cf) : ?>
													<div class="one_customfield">
														<?php if (!empty($cf->display_label)) : ?>
															<?php if (($cf->label_position ?? 'next') === 'over') : ?>
																<div class="one_customfield_label"><?php echo htmlspecialchars((string) $cf->title, ENT_QUOTES, 'UTF-8'); ?></div>
																<div class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></div>
															<?php else : ?>
																<span class="one_customfield_label"><?php echo htmlspecialchars((string) $cf->title, ENT_QUOTES, 'UTF-8'); ?>:</span>
																<span class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></span>
															<?php endif; ?>
														<?php else : ?>
															<span class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></span>
														<?php endif; ?>
													</div>
												<?php endforeach; ?>
											</div>
										<?php endif; ?>
									</div>
								<?php endforeach; ?>
							<?php endif; ?>

							<?php if ($this->params->get('show_intro_text', 1) && !empty($item->introtext)) : ?>
							<?php 
							$introLimit = $this->params->get('introtext_limit', 15);
							$introText = limitWords($item->introtext, $introLimit);
							?>
								<div class="card-text introtext one_grid_introtext">
									<?php echo htmlspecialchars($introText, ENT_QUOTES, 'UTF-8'); ?>
								</div>
							<?php endif; ?>

							<?php if (!empty($item->customfields_under_intro)) : ?>
								<?php foreach ($item->customfields_under_intro as $group) : ?>
									<div class="one_customfield_group one_customfield_group--under-intro mb-2">
										<?php if (!empty($group->fields)) : ?>
											<div class="one_customfields one_customfields--under-intro">
												<?php foreach ($group->fields as $cf) : ?>
													<div class="one_customfield">
														<?php if (!empty($cf->display_label)) : ?>
															<?php if (($cf->label_position ?? 'next') === 'over') : ?>
																<div class="one_customfield_label"><?php echo htmlspecialchars((string) $cf->title, ENT_QUOTES, 'UTF-8'); ?></div>
																<div class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></div>
															<?php else : ?>
																<span class="one_customfield_label"><?php echo htmlspecialchars((string) $cf->title, ENT_QUOTES, 'UTF-8'); ?>:</span>
																<span class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></span>
															<?php endif; ?>
														<?php else : ?>
															<span class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></span>
														<?php endif; ?>
													</div>
												<?php endforeach; ?>
											</div>
										<?php endif; ?>
									</div>
								<?php endforeach; ?>
							<?php endif; ?>

							<?php if ($this->params->get('show_category', 1) && !empty($item->categories)) : ?>
								<div class="item-categories one_grid_categories">
									<span class="one_grid_categories_label"><?php echo Text::_('JCATEGORY') . ': '; ?></span>
									<?php 
									$categoryNames = [];
									foreach ($item->categories as $category) {
										$categoryNames[] = '<span class="one_grid_category_name">' . $this->escape($category->title) . '</span>';
									}
									echo implode(', ', $categoryNames);
									?>
								</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
			<?php endforeach; ?>
		</div>

		<?php if ($this->params->get('show_pagination', 1) && !empty($this->pagination->pagesTotal) && $this->pagination->pagesTotal > 1) : ?>
			<div class="pagination-wrapper one_pagination">
				<?php echo $this->pagination->getPagesLinks(); ?>
			</div>
		<?php endif; ?>
	<?php else : ?>
		<div class="alert alert-info one_no_items">
			<p class="one_no_items_text"><?php echo Text::_('COM_ONECORE_NO_ITEMS_FOUND'); ?></p>
		</div>
	<?php endif; ?>
</div>

<style>
.one_grid_items,
.com-onecore-content.content-grid .items-grid {
	margin-top: 2rem;
}
.one_grid_card,
.com-onecore-content.content-grid .item-card {
	transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
	transform-style: preserve-3d;
	perspective: 1000px;
	border-radius: 8px;
	overflow: hidden;
	background: #fff;
	box-shadow: 
		0 2px 4px rgba(0,0,0,0.08),
		0 1px 2px rgba(0,0,0,0.06);
}
.one_grid_card:hover,
.com-onecore-content.content-grid .item-card:hover {
	transform: translateY(-10px) rotateX(1deg) rotateY(1deg);
	box-shadow: 
		0 20px 40px rgba(0,0,0,0.12),
		0 10px 20px rgba(0,0,0,0.08),
		0 5px 10px rgba(0,0,0,0.05);
}
.one_grid_image,
.com-onecore-content.content-grid .item-image {
	overflow: hidden;
	border-radius: 4px 4px 0 0;
}
.one_grid_image img,
.one_grid_image_img,
.com-onecore-content.content-grid .item-image img {
	width: 100%;
	height: 200px;
	object-fit: cover;
	transition: transform 0.3s ease;
}
.one_grid_card:hover .one_grid_image img,
.one_grid_card:hover .one_grid_image_img {
	transform: scale(1);
}
.one_grid_image_placeholder,
.one_grid_image_placeholder.card-img-top {
	width: 100%;
	height: 200px;
	display: flex;
	flex-direction: column;
	align-items: center;
	justify-content: center;
	border: none;
	position: relative;
	border-radius: 4px 4px 0 0;
	overflow: hidden;
	transition: transform 0.4s cubic-bezier(0.4, 0, 0.2, 1), box-shadow 0.4s ease, background 0.3s ease;
	transform-style: preserve-3d;
	backface-visibility: hidden;
}
.one_grid_image_placeholder::before {
	content: '';
	position: absolute;
	top: 0;
	left: 0;
	right: 0;
	height: 50%;
	background: linear-gradient(180deg, rgba(255,255,255,0.5) 0%, rgba(255,255,255,0.2) 50%, rgba(255,255,255,0) 100%);
	pointer-events: none;
	z-index: 1;
	transition: opacity 0.3s ease;
}
.one_grid_card:hover .one_grid_image_placeholder::before {
	opacity: 0.9;
}
.one_grid_image_placeholder::after {
	content: '';
	position: absolute;
	bottom: 0;
	left: 0;
	right: 0;
	height: 35%;
	background: linear-gradient(0deg, rgba(0,0,0,0.15) 0%, rgba(0,0,0,0.08) 50%, rgba(0,0,0,0) 100%);
	pointer-events: none;
	z-index: 1;
	transition: opacity 0.3s ease;
}
.one_grid_card:hover .one_grid_image_placeholder::after {
	opacity: 0.8;
}
.one_grid_card:hover .one_grid_image_placeholder,
.one_grid_card:hover .one_grid_image_placeholder.card-img-top {
	transform: translateZ(15px) scale(1.03) rotateX(1deg);
	box-shadow: 
		inset 0 4px 8px rgba(255,255,255,0.95),
		inset 0 -4px 8px rgba(0,0,0,0.2),
		0 12px 24px rgba(0,0,0,0.18),
		0 6px 12px rgba(0,0,0,0.15),
		0 3px 6px rgba(0,0,0,0.12),
		0 1px 3px rgba(0,0,0,0.1);
}
.one_grid_placeholder_icon {
	width: 80px;
	height: 80px;
	color: rgba(102, 102, 102, 0.65);
	margin-bottom: 10px;
	position: relative;
	z-index: 2;
	filter: drop-shadow(0 2px 4px rgba(0,0,0,0.12)) drop-shadow(0 1px 2px rgba(255,255,255,0.5));
	transition: transform 0.4s cubic-bezier(0.4, 0, 0.2, 1), color 0.3s ease, filter 0.3s ease;
	transform: translateZ(0);
}
.one_grid_card:hover .one_grid_placeholder_icon {
	transform: translateZ(8px) scale(1.15) rotateY(5deg);
	color: rgba(102, 102, 102, 0.95);
	filter: drop-shadow(0 6px 12px rgba(0,0,0,0.2)) drop-shadow(0 2px 4px rgba(255,255,255,0.6));
}
.one_grid_placeholder_text {
	color: rgba(102, 102, 102, 0.75);
	font-size: 0.9rem;
	text-align: center;
	padding: 0 10px;
	position: relative;
	z-index: 2;
	font-weight: 600;
	letter-spacing: 0.3px;
	text-shadow: 
		0 1px 2px rgba(255,255,255,0.9),
		0 -1px 1px rgba(0,0,0,0.1);
	transition: transform 0.4s cubic-bezier(0.4, 0, 0.2, 1), color 0.3s ease, text-shadow 0.3s ease;
	transform: translateZ(0);
}
.one_grid_card:hover .one_grid_placeholder_text {
	transform: translateZ(8px) translateY(-2px);
	color: rgba(102, 102, 102, 1);
	text-shadow: 
		0 2px 4px rgba(255,255,255,1),
		0 -1px 2px rgba(0,0,0,0.15),
		0 1px 3px rgba(0,0,0,0.1);
}
.one_grid_categories,
.com-onecore-content.content-grid .item-categories {
	margin-top: 0.5rem;
	font-size: 0.9rem;
	color: #666;
}
.one_grid_col--featured .one_grid_card {
	border: 2px solid #dc3545;
}
ul.uk-pagination {
	margin-top: 25px;
}
</style>

