<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

/** @var \Comdev\Component\Onecore\Site\View\Categories\HtmlView $this */
?>
<?php 
// CategoriesView stores items as array with parent id as key
// Check if parent exists and items array is set and not null
$categoryItems = [];
if (isset($this->parent) && isset($this->parent->id) && isset($this->items[$this->parent->id])) {
	$items = $this->items[$this->parent->id];
	// Ensure items is an array and not null
	if (is_array($items)) {
		$categoryItems = $items;
	}
}

// Build a map of category IDs that are children of other categories in the list
// This prevents showing a category both as a main item and as a child
$childrenMap = [];
foreach ($categoryItems as $id => $item) {
	$children = $item->getChildren();
	if (!empty($children)) {
		foreach ($children as $child) {
			$childrenMap[$child->id] = true;
		}
	}
}

// Filter out categories that are children of other categories in the list
$filteredCategoryItems = [];
foreach ($categoryItems as $id => $item) {
	// Only include if it's not a child of another category in the same list
	if (!isset($childrenMap[$id])) {
		$filteredCategoryItems[$id] = $item;
	}
}

// Track displayed subcategories to prevent duplicates
$displayedSubcategoryIds = [];
?>
<?php if ($this->maxLevelcat != 0 && !empty($filteredCategoryItems)) : ?>
	<div class="com-onecore-categories-grid">
		<div class="categories-grid row g-3">
			<?php foreach ($filteredCategoryItems as $id => $item) : ?>
				<?php if ($this->params->get('show_empty_categories_cat') || $item->numitems || count($item->getChildren())) : ?>
				<div class="col-md-4 col-sm-6">
					<div class="category-card card h-100">
						<?php 
						// Get category image if available
						$categoryImage = null;
						if (isset($item->params) && is_object($item->params)) {
							$categoryImage = $item->params->get('image');
						} elseif (isset($item->image)) {
							$categoryImage = $item->image;
						}
						$categoryUrl = Route::_('index.php?option=com_onecore&view=content&id=' . $item->id);
						$children = $item->getChildren();
						
						// Filter out children that are already displayed as main items or as subcategories
						$filteredChildren = [];
						if (!empty($children)) {
							foreach ($children as $child) {
								// Only show child if:
								// 1. It's not in the main filtered list
								// 2. It hasn't been displayed as a subcategory yet
								if (!isset($filteredCategoryItems[$child->id]) && !isset($displayedSubcategoryIds[$child->id])) {
									$filteredChildren[] = $child;
									$displayedSubcategoryIds[$child->id] = true;
								}
							}
						}
						?>
						
						<?php if ($categoryImage) : ?>
							<div class="category-image">
								<a href="<?php echo $categoryUrl; ?>" title="<?php echo $this->escape($item->title); ?>">
									<?php echo HTMLHelper::_('image', $categoryImage, $this->escape($item->title), [
										'class' => 'card-img-top',
										'loading' => 'lazy'
									]); ?>
								</a>
							</div>
						<?php endif; ?>

						<div class="card-body">
							<h3 class="card-title">
								<a href="<?php echo $categoryUrl; ?>">
									<?php echo $this->escape($item->title); ?>
								</a>
							</h3>

							<?php if ($this->params->get('show_subcat_desc_cat') == 1 && !empty($item->description)) : ?>
								<div class="category-description card-text">
									<?php echo HTMLHelper::_('content.prepare', $item->description, '', 'com_onecore.categories'); ?>
								</div>
							<?php endif; ?>

							<?php if ($this->params->get('show_cat_num_articles_cat') == 1 && isset($item->numitems)) : ?>
								<div class="category-count">
									<span class="badge bg-info">
										<?php echo Text::_('COM_ONECORE_NUM_ITEMS'); ?>: <?php echo $item->numitems; ?>
									</span>
								</div>
							<?php endif; ?>

							<?php if (!empty($filteredChildren) && $this->maxLevelcat > 1) : ?>
								<div class="category-subcategories mt-3">
									<h5 class="subcategories-title"><?php echo Text::_('COM_ONECORE_SUBCATEGORIES'); ?>:</h5>
									<ul class="subcategories-list list-unstyled">
										<?php foreach ($filteredChildren as $child) : ?>
											<li>
												<a href="<?php echo Route::_('index.php?option=com_onecore&view=content&id=' . $child->id); ?>">
													<?php echo $this->escape($child->title); ?>
												</a>
												<?php if ($this->params->get('show_cat_num_articles_cat') == 1 && isset($child->numitems)) : ?>
													<small class="text-muted">(<?php echo $child->numitems; ?>)</small>
												<?php endif; ?>
											</li>
										<?php endforeach; ?>
									</ul>
								</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
				<?php endif; ?>
			<?php endforeach; ?>
		</div>
	</div>
<?php else : ?>
	<p><?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?></p>
<?php endif; ?>
