<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Comdev\Component\Onecore\Site\View\Categories;

use Joomla\CMS\MVC\View\CategoriesView;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Content categories view.
 *
 * @since  1.0.0
 */
class HtmlView extends CategoriesView
{
	/**
	 * Language key for default page heading
	 *
	 * @var    string
	 * @since  1.0.0
	 */
	protected $pageHeading = 'COM_ONECORE_CATEGORIES';

	/**
	 * @var    string  The name of the extension for the category
	 * @since  1.0.0
	 */
	protected $extension = 'com_onecore';

	/**
	 * Execute and display a template script.
	 *
	 * @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
	 *
	 * @return  void|boolean
	 *
	 * @since   1.0.0
	 * @throws  \Exception
	 */
	public function display($tpl = null)
	{
		// Ensure Errors is initialized as array to prevent count() errors in parent class
		$errors = $this->get('Errors');
		if ($errors === null) {
			$this->set('Errors', []);
		}

		// Ensure items is initialized as array to prevent count() errors
		$items = $this->get('Items');
		if ($items === null) {
			$items = [];
			$this->set('Items', $items);
		} elseif ($items === false) {
			// Convert false to empty array to prevent issues
			$items = [];
			$this->set('Items', $items);
		}

		// Load CSS
		$this->getDocument()->getWebAssetManager()
			->registerAndUseStyle('com_onecore.categories', 'com_onecore/assets/css/categories.css');

		parent::display($tpl);
	}
}
