<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Comdev\Component\Onecore\Site\Controller;

use Joomla\CMS\Factory;
use Joomla\CMS\Mail\Mail;
use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Uri\Uri;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Content Component Controller
 *
 * @since  1.0.0
 */
class DisplayController extends BaseController
{
	/**
	 * Method to display a view.
	 *
	 * @param   boolean  $cachable   If true, the view output will be cached.
	 * @param   boolean  $urlparams  An array of safe URL parameters and their variable types.
	 *
	 * @return  DisplayController  This object to support chaining.
	 *
	 * @since   1.0.0
	 */
	public function display($cachable = false, $urlparams = false)
	{
		$cachable = true;

		/**
		 * Set the default view name and format from the Request.
		 */
		$vName = $this->input->getCmd('view', 'categories');
		$this->input->set('view', $vName);

		$safeurlparams = [
			'catid'            => 'INT',
			'id'               => 'INT',
			'cid'              => 'ARRAY',
			'limit'            => 'UINT',
			'limitstart'       => 'UINT',
			'showall'          => 'INT',
			'return'           => 'BASE64',
			'filter'           => 'STRING',
			'filter_order'     => 'CMD',
			'filter_order_Dir' => 'CMD',
			'filter-search'    => 'STRING',
			'print'            => 'BOOLEAN',
			'lang'             => 'CMD',
			'Itemid'           => 'INT',
			'search'           => 'STRING',
			'category'         => 'ARRAY',
			'sort'             => 'CMD',
			'date_from'        => 'STRING',
			'date_to'          => 'STRING',
			'event_date_from'  => 'STRING',
			'event_date_to'    => 'STRING',
			'featured'         => 'INT',
			'author'           => 'INT',
			'q'                => 'STRING',
		];

		parent::display($cachable, $safeurlparams);

		return $this;
	}

	/**
	 * Send contact email to listing owner
	 *
	 * @return  void
	 *
	 * @since   1.0.0
	 */
	public function sendContactEmail()
	{
		// Check for request forgeries
		Session::checkToken('post') or jexit(\Joomla\CMS\Language\Text::_('JINVALID_TOKEN'));

		$app = Factory::getApplication();
		$input = $app->input;

		// Get form data
		$contentId = $input->getInt('content_id', 0);
		$name = $input->getString('name', '');
		$email = $input->getString('email', '');
		$subject = $input->getString('subject', '');
		$message = $input->getString('message', '');

		// Validate input
		if (empty($contentId) || empty($name) || empty($email) || empty($message)) {
			$app->enqueueMessage(\Joomla\CMS\Language\Text::_('COM_ONECORE_CONTACT_FORM_ERROR_REQUIRED'), 'error');
			$app->redirect(Route::_('index.php?option=com_onecore&view=item&id=' . $contentId, false));
			return;
		}

		// Validate email
		if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
			$app->enqueueMessage(\Joomla\CMS\Language\Text::_('COM_ONECORE_CONTACT_FORM_ERROR_EMAIL'), 'error');
			$app->redirect(Route::_('index.php?option=com_onecore&view=item&id=' . $contentId, false));
			return;
		}

		// Get content item and owner
		$db = Factory::getDbo();
		$query = $db->getQuery(true)
			->select(['a.id', 'a.title', 'a.created_by', 'u.name', 'u.email'])
			->from($db->quoteName('#__one_content', 'a'))
			->leftJoin($db->quoteName('#__users', 'u'), $db->quoteName('u.id') . ' = ' . $db->quoteName('a.created_by'))
			->where($db->quoteName('a.id') . ' = :id')
			->where($db->quoteName('a.published') . ' = 1')
			->bind(':id', $contentId, \Joomla\Database\ParameterType::INTEGER);

		$db->setQuery($query);
		$item = $db->loadObject();

		if (!$item || empty($item->email)) {
			$app->enqueueMessage(\Joomla\CMS\Language\Text::_('COM_ONECORE_CONTACT_FORM_ERROR_OWNER'), 'error');
			$app->redirect(Route::_('index.php?option=com_onecore&view=item&id=' . $contentId, false));
			return;
		}

		// Prepare email
		$mailer = Factory::getMailer();
		$config = Factory::getConfig();

		$mailer->setSender([$config->get('mailfrom'), $config->get('fromname')]);
		$mailer->addRecipient($item->email);
		$mailer->setSubject(!empty($subject) ? $subject : \Joomla\CMS\Language\Text::sprintf('COM_ONECORE_CONTACT_EMAIL_SUBJECT', $item->title));
		$mailer->setBody(
			\Joomla\CMS\Language\Text::sprintf(
				'COM_ONECORE_CONTACT_EMAIL_BODY',
				$item->name,
				$item->title,
				$name,
				$email,
				$message,
				Uri::root() . Route::_('index.php?option=com_onecore&view=item&id=' . $contentId, false)
			)
		);
		$mailer->isHTML(true);

		// Send email
		try {
			$sent = $mailer->Send();
			if ($sent === true) {
				$app->enqueueMessage(\Joomla\CMS\Language\Text::_('COM_ONECORE_CONTACT_FORM_SUCCESS'), 'success');
			} else {
				$app->enqueueMessage(\Joomla\CMS\Language\Text::_('COM_ONECORE_CONTACT_FORM_ERROR_SEND'), 'error');
			}
		} catch (\Exception $e) {
			$app->enqueueMessage(\Joomla\CMS\Language\Text::_('COM_ONECORE_CONTACT_FORM_ERROR_SEND'), 'error');
		}

		$app->redirect(Route::_('index.php?option=com_onecore&view=item&id=' . $contentId, false));
	}
}
