<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

/**
 * Map container only (address is a separate block). Data via $displayData.
 *
 * Keys: item, height.
 */

$displayData = $displayData ?? [];
$item = $displayData['item'] ?? null;
$height = isset($displayData['height']) ? (int) $displayData['height'] : 300;

if (!$item) {
	return;
}
if ($height < 100) {
	$height = 300;
}
$e = static function ($s) { return htmlspecialchars((string) $s, ENT_QUOTES, 'UTF-8'); };
?>
<div class="onecore-map-container mb-4"
	 data-lat="<?php echo $e($item->latitude ?? ''); ?>"
	 data-lng="<?php echo $e($item->longitude ?? ''); ?>"
	 data-title="<?php echo $e($item->title ?? ''); ?>"
	 style="height: <?php echo $height; ?>px; border: 1px solid #ddd; border-radius: 4px;"></div>
