<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

/**
 * Contact form block. Data via $displayData (FileLayout does not extract).
 *
 * Keys: item, formId, size.
 */

$displayData = $displayData ?? [];
$item = $displayData['item'] ?? null;
$formId = $displayData['formId'] ?? '';
$size = $displayData['size'] ?? 'full';

if (!$item || !isset($item->id)) {
	return;
}

$formAction = Route::_('index.php?option=com_onecore&task=display.sendContactEmail');
$isSmall = $size === 'small';
$formClass = $isSmall ? 'form-control form-control-sm' : 'form-control';
$labelClass = $isSmall ? 'form-label small' : 'form-label';
$headingTag = $isSmall ? 'h4' : 'h3';
$headingClass = 'mb-3';
$rows = $isSmall ? 4 : 5;
$btnClass = $isSmall ? 'btn btn-primary btn-sm w-100' : 'btn btn-primary';
$nameId = $formId . '_name';
$emailId = $formId . '_email';
$subjectId = $formId . '_subject';
$messageId = $formId . '_message';
$e = static function ($s) { return htmlspecialchars((string) $s, ENT_QUOTES, 'UTF-8'); };
?>
<div class="onecore-contact-form mb-4">
	<<?php echo $headingTag; ?> class="<?php echo $headingClass; ?>"><?php echo Text::_('COM_ONECORE_CONTACT_FORM_TITLE'); ?></<?php echo $headingTag; ?>>
	<form id="<?php echo $e($formId); ?>" method="post" action="<?php echo $e($formAction); ?>" class="needs-validation" novalidate>
		<?php echo HTMLHelper::_('form.token'); ?>
		<input type="hidden" name="content_id" value="<?php echo (int) $item->id; ?>" />

		<div class="mb-3">
			<label for="<?php echo $e($nameId); ?>" class="<?php echo $labelClass; ?>"><?php echo Text::_('COM_ONECORE_CONTACT_FORM_NAME'); ?> <span class="text-danger">*</span></label>
			<input type="text" class="<?php echo $formClass; ?>" id="<?php echo $e($nameId); ?>" name="name" required />
			<div class="invalid-feedback"><?php echo Text::_('COM_ONECORE_CONTACT_FORM_NAME_REQUIRED'); ?></div>
		</div>

		<div class="mb-3">
			<label for="<?php echo $e($emailId); ?>" class="<?php echo $labelClass; ?>"><?php echo Text::_('COM_ONECORE_CONTACT_FORM_EMAIL'); ?> <span class="text-danger">*</span></label>
			<input type="email" class="<?php echo $formClass; ?>" id="<?php echo $e($emailId); ?>" name="email" required />
			<div class="invalid-feedback"><?php echo Text::_('COM_ONECORE_CONTACT_FORM_EMAIL_REQUIRED'); ?></div>
		</div>

		<div class="mb-3">
			<label for="<?php echo $e($subjectId); ?>" class="<?php echo $labelClass; ?>"><?php echo Text::_('COM_ONECORE_CONTACT_FORM_SUBJECT'); ?></label>
			<input type="text" class="<?php echo $formClass; ?>" id="<?php echo $e($subjectId); ?>" name="subject" />
		</div>

		<div class="mb-3">
			<label for="<?php echo $e($messageId); ?>" class="<?php echo $labelClass; ?>"><?php echo Text::_('COM_ONECORE_CONTACT_FORM_MESSAGE'); ?> <span class="text-danger">*</span></label>
			<textarea class="<?php echo $formClass; ?>" id="<?php echo $e($messageId); ?>" name="message" rows="<?php echo (int) $rows; ?>" required></textarea>
			<div class="invalid-feedback"><?php echo Text::_('COM_ONECORE_CONTACT_FORM_MESSAGE_REQUIRED'); ?></div>
		</div>

		<button type="submit btn btn-primary" class="<?php echo $btnClass; ?>"><?php echo Text::_('COM_ONECORE_CONTACT_FORM_SUBMIT'); ?></button>
	</form>
</div>
