<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;

/**
 * Address-only block (no map). Data via $displayData.
 *
 * Keys: item.
 */

$displayData = $displayData ?? [];
$item = $displayData['item'] ?? null;

if (!$item) {
	return;
}
if (empty($item->address) && empty($item->address_street) && empty($item->address_city)) {
	return;
}
$addr = !empty($item->address)
	? (string) $item->address
	: implode(' ', array_filter([
		$item->address_street ?? '',
		$item->address_street_number ?? '',
		$item->address_postal_code ?? '',
		$item->address_city ?? '',
		$item->address_country ?? '',
	]));
if (trim($addr) === '') {
	return;
}
?>
<div class="one_item_address onecore-address-block mb-4">
	<h4 class="d-block mb-1"><?php echo Text::_('COM_ONECORE_ADDRESS'); ?>:</h4>
	<div class="one_item_address_value"><?php echo nl2br(htmlspecialchars($addr, ENT_QUOTES, 'UTF-8')); ?></div>
</div>
